<?php

/*
 * LMS version 1.8.0rc5 Rosha
 *
 *  (C) Copyright 2001-2005 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: dblist.php,v 1.31.2.1 2005/12/07 08:56:21 alec Exp $
 */

$layout['pagetitle'] = trans('Database Backups');

if ($handle = opendir($LMS->CONFIG['directories']['backup_dir']))
{
	while (false !== ($file = readdir($handle)))
	{
		if ($file != '.' && $file != '..')
		{
			$path = pathinfo($file);
			
			if(!isset($path['extension']))
				continue;
			
			if($path['extension'] == 'sql')
			{
				if(substr($path['basename'],0,4) == 'lms-')
				{
					$name = substr(basename($file,'.sql'),4,25);
					if($pos = strpos($name,'-'))
					{
						$dblist['dbv'][]  = substr($name, $pos+1);
						$dblist['time'][] = substr($name, 0, $pos);
					} 
					else
					{
						$dblist['dbv'][]  = '';
						$dblist['time'][] = (int) $name;
					}
					
					$dblist['name'][] = $name;
					$dblist['size'][] = filesize($LMS->CONFIG['directories']['backup_dir'].'/'.$file);
					$dblist['type'][] = 'plain';
				}
			}
			elseif(extension_loaded('zlib'))
			{
				if((($path['extension'] == 'gz')&&(strstr($file, "sql.gz")))&& (substr($path['basename'],0,4) == 'lms-'))
				{
					$name = substr(basename($file,'.sql.gz'),4,25);
					if($pos = strpos($name,'-'))
					{
						$dblist['dbv'][]  = substr($name, $pos+1);
						$dblist['time'][] = substr($name, 0, $pos);
					} 
					else
					{
						$dblist['dbv'][]  = FALSE;
						$dblist['time'][] = (int) $name;
					}
					$dblist['name'][] = $name;
					$dblist['size'][] = filesize($LMS->CONFIG['directories']['backup_dir'].'/'.$file);
					$dblist['type'][] = 'gz';
				}
			}
		}
	}
	closedir($handle);
}

if(sizeof($dblist['time']))
	array_multisort($dblist['time'],$dblist['size'],$dblist['type'],$dblist['dbv'],$dblist['name']);

$dblist['total'] = sizeof($dblist['time']);

$SMARTY->assign('dblist', $dblist);
$SMARTY->display('dblist.html');

?>
