/*
 * LMS version 1.7.4 Wraith
 *
 *  (C) Copyright 2001-2005 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: traffic.c,v 1.10 2005/05/13 20:23:37 alec Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <string.h>

#include "lmsd.h"
#include "traffic.h"

unsigned long inet_addr(unsigned char*);
unsigned char * inet_ntoa(unsigned long);

char * itoa(int i)
{
	static char string[15];
	sprintf(string, "%d", i);
	return string;
}

int is_host(HOSTS *hosts, int n, unsigned char *ip)
{
	int i;
	for(i=0; i<n; i++)
		if( strcmp(hosts[i].ipaddr, ip)==0 )
			return hosts[i].id;
	return 0;
} 

void reload(GLOBAL *g, struct traffic_module *traffic)
{
	QueryHandle *res;
	int i, k, j=0;
	HOSTS *hosts = NULL;
	FILE *fh;
	
	// first get hosts data
	res = g->db_query(g->conn, "SELECT id, ipaddr FROM nodes");

	if( g->db_nrows(res) )
	{
		for(i=0; i<g->db_nrows(res); i++)
		{
			hosts = (HOSTS *) realloc(hosts, sizeof(HOSTS) * (j + 1));
			hosts[i].ipaddr = strdup(inet_ntoa(inet_addr(g->db_get_data(res,i,"ipaddr"))));
			hosts[i].id = atoi(g->db_get_data(res,i,"id"));
			j++;
		}	
		
		// open log file for reading
		fh = fopen(traffic->file,"r");
		if(fh)
		{
			unsigned char *buffer, *host, *download, *upload;
			
			buffer = (char *) malloc(100+1);
			host = (char *) malloc(100+1);
			download = (char *) malloc(100+1);
			upload = (char *) malloc(100+1);
			
			// read file line by line
			while( fgets(buffer, 100, fh)!=NULL )
			{
				if ( sscanf(buffer, "%[^\t ] %[^\t ] %s", host, upload, download) !=3 )
					continue; //if invalid data format
					 
				if( (k = is_host(hosts, j, host)) ) // host exists ?
				{
					if( atoi(download) || atoi(upload) ) // write not null data
					{
						g->db_pexec(g->conn, "INSERT INTO stats (nodeid, dt, download, upload) VALUES (?, %NOW%, ?, ?)", itoa(k), download, upload);
					}
				}
			}
			free(buffer);
			free(host);
			free(download);
			free(upload);
		}
		else
			syslog(LOG_ERR, "[%s/traffic] Unable to read file '%s'",traffic->base.instance, traffic->file);
		
		for(i=0; i<j; i++) free(hosts[i].ipaddr);
#ifdef DEBUG1
		syslog(LOG_INFO, "DEBUG: [%s/traffic] reloaded", traffic->base.instance);
#endif
	} 
	else 
		syslog(LOG_ERR, "[%s/traffic] Unable to read table 'nodes'", traffic->base.instance);

	g->db_free(&res);
	free(hosts);
	free(traffic->file);
}

struct traffic_module * init(GLOBAL *g, MODULE *m)
{
	struct traffic_module *traffic;
	
	if(g->api_version != APIVERSION)
	{
		return (NULL);
	}
	
	traffic = (struct traffic_module *) realloc(m, sizeof(struct traffic_module));
	
	traffic->base.reload = (void (*)(GLOBAL *, MODULE *)) &reload;

	traffic->file = strdup(g->config_getstring(traffic->base.ini, traffic->base.instance, "file", "/var/log/traffic.log"));
	
#ifdef DEBUG1
	syslog(LOG_INFO,"DEBUG: [%s/traffic] initialized", traffic->base.instance);
#endif	
	return(traffic);
}
	
