<?php

/*
 * LMS version 1.6.1 Ishta
 *
 *  (C) Copyright 2001-2005 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: LMSDB_driver_mysql.class.php,v 1.32.2.1 2005/05/13 20:09:53 alec Exp $
 */

/*
 * To jest pseudo-driver dla LMSDB, dla bazy danych 'mysql'.
 */

class LMSDB_driver_mysql extends LMSDB_common
{
	var $_loaded = TRUE;
	var $_dbtype = 'mysql';
	var $iconv = NULL;

	function LMSDB_driver_mysql($dbhost, $dbuser, $dbpasswd, $dbname)
	{
		$this->_version .= ' (core: '.eregi_replace('^.Revision: ([0-9.]+).*','\1',$this->_revision).' / driver: '.$this->_dbtype.' '.eregi_replace('^.Revision: ([0-9.]+).*','\1','$Revision: 1.32.2.1 $').')';
		$this->Connect($dbhost, $dbuser, $dbpasswd, $dbname);
	}
	
	function _driver_dbversion()
	{
		return mysql_get_server_info();
	}

	function _driver_connect($dbhost, $dbuser, $dbpasswd, $dbname)
	{
		if($this->_dblink = @mysql_connect($dbhost,$dbuser,$dbpasswd))
		{
			$this->_dbhost = $dbhost;
			$this->_dbuser = $dbuser;
			$this->_driver_selectdb($dbname);
		}
		else
		{
			$this->_error = TRUE;
		}
		return $this->_dblink;
	}

	function _driver_shutdown()
	{
		$this->_loaded = FALSE;
		// mysql_close($this->_dblink); - apparently, mysql_close() is automagicly called after end of the script...
	}
	
	function _driver_geterror()
	{
		if($this->_dblink)
			return mysql_error($this->_dblink);
		elseif($this->_query)
			return 'We\'re not connected!';
		else
			return mysql_error();
	}

	function _driver_disconnect()
	{
		return @mysql_close($this->_dblink);
	}
	
	function _driver_selectdb($dbname)
	{
		if($result = mysql_select_db($dbname, $this->_dblink))
			$this->_dbname = $dbname;
		return $result;
	}

	function _driver_execute($query)
	{
		$this->_query = $query;
		
		if($this->iconv)
			$query = iconv('UTF-8', $this->iconv, $query);

		if($this->_result = @mysql_query($query, $this->_dblink))
			$this->_error = FALSE;
		else
			$this->_error = TRUE;
		return $this->_result;
	}

	function _driver_fetchrow_assoc()
	{
		if(! $this->_error)
		{
			$result =  mysql_fetch_array($this->_result, MYSQL_ASSOC);
			
			if(!$this->iconv)
				return $result;
			else
			{
				if($result)
					foreach($result as $idx => $val)
						$result[$idx] = iconv($this->iconv, 'UTF-8', $val);
				return $result;
			}
		}
		else
			return FALSE;
	}

	function _driver_fetchrow_num()
	{
		if(! $this->_error)
		{
			$result = mysql_fetch_array($this->_result, MYSQL_NUM);
			
			if(!$this->iconv)
				return $result;
			else
			{
				if($result)
					foreach($result as $idx => $val)
						$result[$idx] = iconv($this->iconv, 'UTF-8', $val);
				return $result;
			}
		}
		else
			return FALSE;
	}

	function _driver_affected_rows()
	{
		if(! $this->_error)
			return mysql_affected_rows();
		else
			return FALSE;
	}
	
	function _driver_now()
	{
		return 'UNIX_TIMESTAMP()';
	}

	function _driver_like()
	{
		return 'LIKE';
	}

	function _driver_concat($input)
	{
		$return = implode(', ', $input);
		return 'CONCAT('.$return.')';
	}

	function _driver_listtables()
	{
		$this->_result = mysql_list_tables($this->_dbname, $this->_dblink);
		return $this->GetCol();
	}

	function _driver_begintrans()
	{
		// mysql nie obsuguje transakcji
		return TRUE;
	}

	function _driver_committrans()
	{
		return TRUE;
	}
}

?>
