#! /bin/bash
# ------ Przykadowy skrypt dla lms-traffic --------
# Skrypt 
zliczajcy ruch dla kadego usera na podstawie
# licznikw iptables. Naley go uruchamia z crona 
# na przykad co 10 minut
.
# Na firewallu naley utworzy acuchy zliczajce ruch:
# iptables -N RECV
# iptables -N SEND
# i nastpnie dla kadego komputera reguki:
# iptables -A RECV -d <IP komputera w sieci LAN> 
-j RETURN
# iptables -A SEND -s <IP komputera w sieci LAN> -j RETURN
# i na koncu:
# iptables -A FORWARD -j RECV
# iptables -A FORWARD -j SEND

#--------Ustawienie staych uytkownika----------------
hosty=" \		# kocwki adresw sieciowych
0.1 0.2 0.3 0.4 1.5 1.6 1.7 1.8 1.9 1.10 \
1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 1.10 \
1.11 1.12 "
net='192.168'			# sie
log='/var/log/traffic.log'	# katalog ze statystyk
ipt='/usr/sbin/iptables'	
#--------------------------------------------------------

# odczyt licznikw firewalla i zapis do pliku. 
$ipt -L RECV -v -x -n > /tmp/recv.stat
$ipt -L SEND -v -x -n > /tmp/send.stat

# usunicie poprzedniego loga
if [ -e $log ]
then
    rm $log
fi

# zapis aktualnych danych dla kadego IP osobno
# do pliku odczytywanego przez skrypt lms-traffic 
# w formacie: <adres IP> <upload> <download>
for host in $hosty
    do
    recv=`cat /tmp/recv.stat | grep $net.$host' ' | cut -c10-18`
    send=`cat /tmp/send.stat | grep $net.$host' ' | cut -c10-18`
    echo -e $net.$host ' ' $send ' ' $recv >> $log
done

# zerowanie licznikw iptables
$ipt -Z

# usunicie plikw tymczasowych
rm /tmp/recv.stat
rm /tmp/send.stat

# $Id: traffic_ipt.sh,v 1.2 2003/09/09 19:52:40 alec Exp $