<?php

/*
 * LMS version 1.11.7 Bastet
 *
 *  (C) Copyright 2001-2009 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: voipaccountedit.php,v 1.2 2009/01/13 07:45:56 alec Exp $
 */

if(!$LMS->VoipAccountExists($_GET['id']))
	if(isset($_GET['ownerid']))
		header('Location: ?m=customerinfo&id='.$_GET['ownerid']);
	else
		header('Location: ?m=voipaccountlist');

$voipaccountid = intval($_GET['id']);
$ownerid = $LMS->GetVoipAccountOwner($voipaccountid);
$voipaccountinfo = $LMS->GetVoipAccount($voipaccountid);

if(!isset($_GET['ownerid']))
	$SESSION->save('backto', $SESSION->get('backto') . '&ownerid='.$ownerid);
else
	$SESSION->save('backto', $_SERVER['QUERY_STRING']);
							
$layout['pagetitle'] = trans('Voip Account Edit: $0', $voipaccountinfo['login']);

if(isset($_POST['voipaccountedit']))
{
	$voipaccountedit = $_POST['voipaccountedit'];
	
	foreach($voipaccountedit as $key => $value)
		$voipaccountedit[$key] = trim($value);
	
	if($voipaccountedit['login']=='')
		$error['login'] = trans('Voip account login is required!');
	else
	{
		$loginids = $LMS->GetVoipAccountIDByLogin($voipaccountedit['login']);

		$foundid = 0;
		if(isset($loginids))
			foreach($loginids as $loginid)
			{
				$foundid = ($loginid['id'] == $voipaccountedit['id']);
				if($foundid)
					break;
				else
					$error['login'] = trans('Specified login is in use!');
			}
/*		if($foundid)
		{
			$phoneid = $LMS->GetVoipAccountIDByPhone($voipaccountedit['phone']);
			if(isset($phoneid) && $phoneid != $foundid)
				$error['login'] = trans('Specified login is in use!');
		}
*/

	}
	if(!$error['login'])
		if(!eregi('^[_a-z0-9-]+$',$voipaccountedit['login']))
			$error['login'] = trans('Specified login contains forbidden characters!');
		elseif(strlen($voipaccountedit['login'])>32)
			$error['login'] = trans('Voip account login is too long (max.32 characters)!');

	if($voipaccountedit['passwd']=='')
		$error['passwd'] = trans('Voip account password is required!');
	elseif(strlen($voipaccountedit['passwd']) > 32)
		$error['passwd'] = trans('Voip account password is too long (max.32 characters)!');
	elseif(!eregi('^[_a-z0-9-]+$', $voipaccountedit['passwd']))
		$error['passwd'] = trans('Specified password contains forbidden characters!');		

	if($voipaccountedit['phone']=='')
		$error['phone'] = trans('Voip account phone number is required!');
	elseif(strlen($voipaccountedit['phone']) > 32)
		$error['phone'] = trans('Voip account phone number is too long (max.32 characters)!');
	elseif($LMS->GetVoipAccountIDByPhone($voipaccountedit['phone']) && $LMS->GetVoipAccountIDByPhone($voipaccountedit['phone']) != $voipaccountedit['id'])
		$error['phone'] = trans('Specified phone is in use!');
	elseif(!eregi('^[0-9]+$', $voipaccountedit['phone']))
		$error['phone'] = trans('Specified phone number contains forbidden characters or is too short!');

	if(!$LMS->CustomerExists($voipaccountedit['ownerid']))
		$error['customer'] = trans('You have to select owner!');
	else
	{
		$status = $LMS->GetCustomerStatus($voipaccountedit['ownerid']);
		if($status == 1) // unknown (interested)
			$error['customer'] = trans('Selected customer is not connected!');
		elseif($status == 2) // awaiting
	                $error['customer'] = trans('Voip account owner is not connected!');
	}

	$voipaccountinfo['login'] = $voipaccountedit['login'];
	$voipaccountinfo['passwd'] = $voipaccountedit['passwd'];
	$voipaccountinfo['phone'] = $voipaccountedit['phone'];
	$voipaccountinfo['ownerid'] = $voipaccountedit['ownerid'];

	if(!$error)
	{
		$LMS->VoipAccountUpdate($voipaccountedit);
		$SESSION->redirect('?m=voipaccountinfo&id='.$voipaccountedit['id']);
		die;
	}
}

$customerinfo = $LMS->GetCustomer($ownerid);
$customers = $LMS->GetCustomerNames();
$tariffs = $LMS->GetTariffs();
$assignments = $LMS->GetCustomerAssignments($ownerid);
$balancelist = $LMS->GetCustomerBalanceList($ownerid);
$customergroups = $LMS->CustomergroupGetForCustomer($ownerid);
$othercustomergroups = $LMS->GetGroupNamesWithoutCustomer($ownerid);
$documents = $LMS->GetDocuments($ownerid, 10);
$netdevices = $LMS->GetNetDevNames();
$taxeslist = $LMS->GetTaxes();
$customernodes = $LMS->GetCustomerNodes($ownerid);
$customervoipaccounts = $LMS->GetCustomerVoipAccounts($ownerid);
$allnodegroups = $LMS->GetNodeGroupNames();

if(isset($CONFIG['phpui']['ewx_support']) && chkconfig($CONFIG['phpui']['ewx_support']))
{
        $SMARTY->assign('ewx_channelid', $DB->GetOne('SELECT MAX(channelid) FROM ewx_stm_nodes, nodes
                                        WHERE nodeid = nodes.id AND ownerid = ?', array($ownerid)));
}

$SMARTY->assign('netdevices',$netdevices);
$SMARTY->assign('balancelist',$balancelist);
$SMARTY->assign('assignments',$assignments);
$SMARTY->assign('customernodes',$customernodes);
$SMARTY->assign('customervoipaccounts',$customervoipaccounts);
$SMARTY->assign('customergroups',$customergroups);
$SMARTY->assign('othercustomergroups',$othercustomergroups);
$SMARTY->assign('allnodegroups',$allnodegroups);
$SMARTY->assign('tariffs',$tariffs);
$SMARTY->assign('error',$error);
$SMARTY->assign('customerinfo',$customerinfo);
$SMARTY->assign('voipaccountinfo',$voipaccountinfo);
$SMARTY->assign('customers',$customers);
$SMARTY->assign('documents', $documents);
$SMARTY->assign('taxeslist', $taxeslist);
$SMARTY->display('voipaccountedit.html');

?>
