<?php

/*
 * LMS version 1.11.7 Bastet
 *
 *  (C) Copyright 2001-2009 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: voipaccountadd.php,v 1.2 2009/01/13 07:45:56 alec Exp $
 */

$voipaccountdata['ownerid'] = 0;

if(isset($_GET['ownerid']))
{
	if($LMS->CustomerExists($_GET['ownerid']) == true)
	{
		$voipaccountdata['ownerid'] = $_GET['ownerid'];
		$customerinfo = $LMS->GetCustomer($_GET['ownerid']);
		$SMARTY->assign('customerinfo', $customerinfo);
	}
	else
		$SESSION->redirect('?m=voipaccountinfo&id='.$_GET['ownerid']);
}

if(isset($_GET['prelogin']))
	$voipaccountdata['login'] = $_GET['prelogin'];

if(isset($_GET['prepasswd']))
	$voipaccountdata['passwd'] = $_GET['prepasswd'];

if(isset($_GET['prephone']))
	$voipaccountdata['phone'] = $_GET['prephone'];

if(isset($_POST['voipaccountdata']))
{
	$voipaccountdata = $_POST['voipaccountdata'];

	foreach($voipaccountdata as $key => $value)
		$voipaccountdata[$key] = trim($value);

	if($voipaccountdata['login']=='')
		$error['login'] = trans('Voip account login is required!');
	elseif(strlen($voipaccountdata['login']) > 32)
		$error['login'] = trans('Voip account login is too long (max.32 characters)!');
	//elseif($LMS->GetVoipAccountIDByLogin($voipaccountdata['login']) && $LMS->GetVoipAccountIDByPhone($voipaccountdata['phone']))
	elseif($LMS->GetVoipAccountIDByLogin($voipaccountdata['login']))
		$error['login'] = trans('Specified login is in use!');
	elseif(!eregi('^[_a-z0-9-]+$', $voipaccountdata['login']))
		$error['login'] = trans('Specified login contains forbidden characters!');		

	if($voipaccountdata['passwd']=='')
		$error['passwd'] = trans('Voip account password is required!');
	elseif(strlen($voipaccountdata['passwd']) > 32)
		$error['passwd'] = trans('Voip account password is too long (max.32 characters)!');
	elseif(!eregi('^[_a-z0-9-]+$', $voipaccountdata['passwd']))
		$error['passwd'] = trans('Specified password contains forbidden characters!');		

	if($voipaccountdata['phone']=='')
		$error['phone'] = trans('Voip account phone number is required!');
	elseif(strlen($voipaccountdata['phone']) > 32)
		$error['phone'] = trans('Voip account phone number is too long (max.32 characters)!');
	elseif($LMS->GetVoipAccountIDByPhone($voipaccountdata['phone']))
		$error['phone'] = trans('Specified phone is in use!');
	elseif(!eregi('^[0-9]+$', $voipaccountdata['phone']))
		$error['phone'] = trans('Specified phone number contains forbidden characters or is too short!');		

	if(!$LMS->CustomerExists($voipaccountdata['ownerid']))
		$error['customer'] = trans('You have to select owner!');
	else
	{
		$status = $LMS->GetCustomerStatus($voipaccountdata['ownerid']);
		if($status == 1) // unknown (interested)
			$error['customer'] = trans('Selected customer is not connected!');
		elseif($status == 2) // awaiting
	                $error['customer'] = trans('Voip account owner is not connected!');
	}

	if(!$error)
	{
		$voipaccountid = $LMS->VoipAccountAdd($voipaccountdata);

		if(!isset($voipaccountdata['reuse']))
		{
			$SESSION->redirect('?m=voipaccountinfo&id='.$voipaccountid);
		}
		
		$ownerid = $voipaccountdata['ownerid'];
		unset($voipaccountdata);
		
		$voipaccountdata['ownerid'] = $ownerid;
		$voipaccountdata['reuse'] = '1';
	}
}

$layout['pagetitle'] = trans('New Voip Account');

$customers = $LMS->GetCustomerNames();

if($voipaccountdata['ownerid'])
{
	$SMARTY->assign('balancelist', $LMS->GetCustomerBalanceList($voipaccountdata['ownerid']));
	$SMARTY->assign('assignments', $LMS->GetCustomerAssignments($voipaccountdata['ownerid']));
	$SMARTY->assign('customergroups', $LMS->CustomergroupGetForCustomer($voipaccountdata['ownerid']));
	$SMARTY->assign('customernodes', $LMS->GetCustomerNodes($voipaccountdata['ownerid']));
	$SMARTY->assign('customervoipaccounts', $LMS->GetCustomerVoipAccounts($voipaccountdata['ownerid']));
	$SMARTY->assign('othercustomergroups', $LMS->GetGroupNamesWithoutCustomer($voipaccountdata['ownerid']));
	$SMARTY->assign('allnodegroups', $LMS->GetNodeGroupNames());
	$SMARTY->assign('documents', $LMS->GetDocuments($voipaccountdata['ownerid'], 10));
	$SMARTY->assign('taxeslist', $LMS->GetTaxes());
	$SMARTY->assign('tariffs', $LMS->GetTariffs());

	if(isset($CONFIG['phpui']['ewx_support']) && chkconfig($CONFIG['phpui']['ewx_support']))
	{
		$SMARTY->assign('ewx_channelid', $DB->GetOne('SELECT MAX(channelid) FROM ewx_stm_nodes, nodes
			WHERE nodeid = nodes.id AND ownerid = ?', array($voipaccountdata['ownerid'])));
        }
}
																				
$SMARTY->assign('customers', $customers);
$SMARTY->assign('error', $error);
$SMARTY->assign('voipaccountdata', $voipaccountdata);
$SMARTY->display('voipaccountadd.html');

?>
