<?php

/*
 * LMS version 1.11.7 Bastet
 *
 *  (C) Copyright 2001-2009 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: trafficdbcompact.php,v 1.29 2009/01/13 07:45:54 alec Exp $
 */

$layout['pagetitle'] = trans('Network Statistics Compacting');

if (!isset($_GET['level']) && !isset($_GET['removeold']) && !isset($_GET['removedeleted']))
{
    $SMARTY->display('trafficdbcompact.html');
    $SESSION->close();
    die;
}

set_time_limit(0);

$layout['nomenu'] =  TRUE;
$SMARTY->display('header.html');

echo '<BR><BLOCKQUOTE><H1>'.trans('Compacting Database').'</H1><PRE>';
echo trans('$0 records before compacting.<BR>',$DB->GetOne('SELECT COUNT(*) FROM stats'));
flush();

if(isset($_GET['removeold']))
{
    $yeardeleted = $DB->Execute('DELETE FROM stats where dt < ?NOW? - 365*24*60*60');
    echo trans('$0 at least one year old records have been removed.<BR>',$yeardeleted);
    flush();
}

if(isset($_GET['removedeleted']))
{
	if($deleted_nodes = $DB->GetCol("SELECT DISTINCT nodeid FROM stats WHERE nodeid NOT IN ((SELECT id FROM nodes)) ORDER BY nodeid"))
	{
		$first_record = true;

		foreach($deleted_nodes as $nodeid)
		{
			if ($first_record)
			{
				$deleted_nodes_sql = $nodeid;
				$first_record = false;
			}
			else
				$deleted_nodes_sql = $deleted_nodes_sql . "," . $nodeid;
		}

		if($DB->Execute("DELETE FROM stats WHERE nodeid IN ($deleted_nodes_sql)"))
		{
			foreach($deleted_nodes as $nodeid)
				echo trans('Statistics for computer $0 has been removed<BR>',$nodeid);
		}
		else
			echo trans('Error during deleting data for old computers !<BR>');
	}
	flush();
}

if(isset($_GET['level']))
{
    $time = time();
    switch($_GET['level'])
    {
	case 'low' : $period = $time-24*60*60; $step = 24*60*60; break; //1 day, day
	case 'medium' : $period = $time-30*24*60*60; $step = 24*60*60; break;//month, day
	case 'high' : $period = $time-365*24*60*60; $step = 60*60; break; //month, hour
    }
    if($mintime = $DB->GetOne('SELECT MIN(dt) FROM stats'))
    {
	$nodes = $DB->GetAll('SELECT id, name FROM nodes ORDER BY name');
	foreach($nodes as $node)
	{
    	    echo "'".$node['name']."'\t: "; 
	    $deleted = 0;
	    $inserted = 0;
	    $DB->BeginTrans();
	    $maxtime = $period;
	    $timeoffset = date('Z');
	    $dtdivider = '((dt+'.$timeoffset.')/'.$step.')';
	    $data = $DB->GetAll('SELECT SUM(download) AS download, SUM(upload) AS upload, COUNT(dt) AS count, '.$dtdivider.' AS day, 
	    	MIN(dt) AS mintime, MAX(dt) AS maxtime FROM stats WHERE nodeid=? AND dt >= ? AND dt < ? 
		GROUP BY nodeid, '.$dtdivider.' ORDER BY '.$dtdivider, array($node['id'], $mintime, $maxtime));
	    $DB->Execute('DELETE FROM stats WHERE nodeid=? AND dt >= ? AND dt <= ?',
	    	array($node['id'], $mintime, $maxtime));
	    if($data != NULL)
		    foreach($data as $record)
		    {
			$deleted += $record['count'];
			if($record['download'] || $record['upload'])
				$inserted += $DB->Execute('INSERT INTO stats (nodeid, dt, download, upload) VALUES (?, ?, ?, ?)',
					array($node['id'], $record['maxtime'], $record['upload'], $record['download']));
		    }
	    $DB->CommitTrans();
	    echo trans('$0 - removed, $1 - inserted<BR>', $deleted, $inserted);
	    flush();
	}
    }
}

echo trans('$0 records after compacting.<BR>',$DB->GetOne("SELECT COUNT(*) FROM stats"));
echo '<P><BR><B><A HREF="javascript:window.close();">'.trans('You can close this window now.').'</A></B></BLOCKQUOTE>';
flush();

$SMARTY->display('footer.html');

?>
