<?php

/*
 * LMS version 1.11.7 Bastet
 *
 *  (C) Copyright 2001-2009 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: tariffedit.php,v 1.49 2009/01/13 07:45:54 alec Exp $
 */

if(!$LMS->TariffExists($_GET['id']))
{
	$SESSION->redirect('?m=tarifflist');
}

if(isset($_POST['tariff']))
{
	$tariff = $_POST['tariff'];
	$limit = isset($_POST['limit']) ? $_POST['limit'] : array();

	foreach($tariff as $key => $value)
		$tariff[$key] = trim($value);

	$tariff['value'] = str_replace(',','.',$tariff['value']);
	
	$items = array('uprate', 'downrate', 'upceil', 'downceil', 'climit', 'plimit', 'dlimit');
	
	foreach($items as $item)
	{
	        if($tariff[$item]=='')
	                $tariff[$item] = 0;
	        elseif(!ereg('^[0-9]+$', $tariff[$item]))
	                $error[$item] = trans('Integer value expected!');
	}

	if($tariff['name'] == '')
		$error['name'] = trans('Subscription name required!');
	elseif($LMS->GetTariffIDByName($tariff['name']) 
		&& $tariff['name'] != $DB->GetOne('SELECT name FROM tariffs WHERE id=?', array($_GET['id'])))
	{
		$error['name'] = trans('Subscription with specified name already exists!');
	}
	
	if($tariff['value'] == '')
		$error['value'] = trans('Value required!');
	elseif(!(ereg('^[-]?[0-9.,]+$', $tariff['value'])))
		$error['value'] = trans('Incorrect value!');
	
	if(($tariff['uprate'] < 8 || $tariff['uprate'] > 100000) && $tariff['uprate'] != 0)
		$error['uprate'] = trans('This field must be within range 8 - 100000');
	if(($tariff['downrate'] < 8 || $tariff['downrate'] > 100000) && $tariff['downrate'] != 0)
		$error['downrate'] = trans('This field must be within range 8 - 100000');
	if(($tariff['upceil'] < 8 || $tariff['upceil'] < $tariff['uprate']) && $tariff['upceil'] != 0)
		$error['upceil'] = trans('This field must be greater than 8 and greater than upload rate');
	if(($tariff['downceil'] < 8 || $tariff['downceil'] < $tariff['downrate']) && $tariff['downceil'] != 0)
		$error['downceil'] = trans('This field must be greater than 8 and greater than download rate');

	if(!isset($tariff['taxid']))
		$tariff['taxid'] = 0;

	$items = array('domain_limit', 'alias_limit',
                        'sh_limit', 'mail_limit', 'www_limit', 'ftp_limit', 'sql_limit',
	                'quota_sh_limit', 'quota_mail_limit', 'quota_www_limit',
	                'quota_ftp_limit', 'quota_sql_limit',
	);
										
	foreach($items as $item)
	{
	        if(isset($limit[$item]))
		        $tariff[$item] = NULL;
	        elseif(!ereg('^[0-9]+$', $tariff[$item]))
	                $error[$item] = trans('Integer value expected!');
	}

	$tariff['id'] = $_GET['id'];

	if(!$error)
	{
		$LMS->TariffUpdate($tariff);
		$SESSION->redirect('?m=tariffinfo&id='.$tariff['id']);
	}
}
else
	$tariff = $LMS->GetTariff($_GET['id']);
	
$layout['pagetitle'] = trans('Subscription Edit: $0',$tariff['name']);

$SMARTY->assign('tariff',$tariff);
$SMARTY->assign('taxeslist',$LMS->GetTaxes());
$SMARTY->assign('error',$error);
$SMARTY->display('tariffedit.html');

?>
