<?php

/*
 * LMS version 1.11.7 Bastet
 *
 *  (C) Copyright 2001-2009 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: invoicereport.php,v 1.42 2009/01/13 07:45:51 alec Exp $
 */

$from = $_POST['from'];
$to = $_POST['to'];

// date format 'yyyy/mm/dd'	
if($from) {
	list($year, $month, $day) = split('/',$from);
	$unixfrom = mktime(0,0,0,$month,$day,$year);
} else { 
	$from = date('Y/m/d',time());
	$unixfrom = mktime(0,0,0); //today
}
if($to) {
	list($year, $month, $day) = split('/',$to);
	$unixto = mktime(23,59,59,$month,$day,$year);
} else { 
	$to = date('Y/m/d',time());
	$unixto = mktime(23,59,59); //today
}

$layout['pagetitle'] = trans('Sale Registry for period $0 - $1', $from, $to);

$listdata = array('tax' => 0, 'brutto' => 0);
$invoicelist = array();
$taxeslist = array();

if(!empty($_POST['group']))
{
	if(is_array($_POST['group']))
		$groups = implode(',', $_POST['group']);
	else
		$groups = intval($_POST['group']);
	
	$groupwhere = ' AND '.(isset($_POST['groupexclude']) ? 'NOT' : '').' 
		EXISTS (SELECT 1 FROM customerassignments a
			WHERE a.customergroupid IN ('.$groups.')
			AND a.customerid = d.customerid)';

        $names = $DB->GetAll('SELECT name FROM customergroups WHERE id IN ('.$groups.')');
	
	$groupnames = '';
	foreach($names as $idx => $row)
		$groupnames .= ($idx ? ', ' : '') . $row['name'];
	
	if(isset($_POST['groupexclude']))
	        $layout['group'] = trans('Group: all excluding $0', $groupnames);
	else
	        $layout['group'] = trans('Group: $0', $groupnames);
}

if(!empty($_POST['division']))
{
	$divwhere = ' AND d.divisionid '.(isset($_POST['divexclude']) ? '!=' : '=').' '.intval($_POST['division']);

        $divname = $DB->GetOne('SELECT name FROM divisions WHERE id = ?', 
			array(intval($_POST['division'])));
	
        $layout['division'] = $divname;
}

// we can't simply get documents with SUM(value*count)
// because we need here incoices-like round-off

// get documents items numeric values for calculations
$items = $DB->GetAll('SELECT docid, itemid, taxid, value, count
	    FROM documents d
	    LEFT JOIN invoicecontents ON docid = d.id 
	    WHERE (type = ? OR type = ?) AND (cdate BETWEEN ? AND ?) '
	    .($_POST['numberplanid'] ? 'AND d.numberplanid = '.intval($_POST['numberplanid']) : '')
	    .(isset($divwhere) ? $divwhere : '')
	    .(isset($groupwhere) ? $groupwhere : '')
	    .' AND NOT EXISTS (
                	    SELECT 1 FROM customerassignments a
			    JOIN excludedgroups e ON (a.customergroupid = e.customergroupid)
			    WHERE e.userid = lms_current_user() AND a.customerid = d.customerid)
	    ORDER BY CEIL(cdate/86400), d.id', array(DOC_INVOICE, DOC_CNOTE, $unixfrom, $unixto));

// get documents data
$docs = $DB->GetAllByKey('SELECT d.id AS id, number, cdate, customerid, name, address, zip, city, ten, ssn, template, reference
	    FROM documents d
	    LEFT JOIN numberplans ON d.numberplanid = numberplans.id
	    WHERE (d.type = ? OR d.type = ?) AND (d.cdate BETWEEN ? AND ?) '
	    .($_POST['numberplanid'] ? 'AND d.numberplanid = '.intval($_POST['numberplanid']) : '')
	    .(isset($groupwhere) ? $groupwhere : '')
	    , 'id', array(DOC_INVOICE, DOC_CNOTE, $unixfrom, $unixto));

if($items)
{
	// get taxes for calculations
	$taxes = $LMS->GetTaxes();

	foreach($items as $row)
	{
		$idx = $row['docid'];
		$doc = $docs[$idx];
		$taxid = $row['taxid'];
		
		$invoicelist[$idx]['custname'] = $doc['name'];
		$invoicelist[$idx]['custaddress'] = $doc['zip'].' '.$doc['city'].', '.$doc['address'];
		$invoicelist[$idx]['ten'] = ($doc['ten'] ? trans('TEN').' '.$doc['ten'] : ($doc['ssn'] ? trans('SSN').' '.$doc['ssn'] : ''));
		$invoicelist[$idx]['number'] = docnumber($doc['number'], $doc['template'], $doc['cdate']);
		$invoicelist[$idx]['cdate'] = $doc['cdate'];
		$invoicelist[$idx]['customerid'] = $doc['customerid'];

		if(!isset($invoicelist[$idx][$taxid]))
		{
			$invoicelist[$idx][$taxid]['tax'] = 0;
			$invoicelist[$idx][$taxid]['val'] = 0;
		}
		
		if(!isset($invoicelist[$idx]['tax'])) $invoicelist[$idx]['tax'] = 0;
		if(!isset($invoicelist[$idx]['brutto'])) $invoicelist[$idx]['brutto'] = 0;
		
		if($doc['reference'])
		{
			// I think we can simply do query here instead of building
			// big sql join in $items query, we've got so many credit notes?
			$item = $DB->GetRow('SELECT taxid, value, count
						FROM invoicecontents 
						WHERE docid=? AND itemid=?', 
						array($doc['reference'], $row['itemid']));

			$row['value'] += $item['value'];
			$row['count'] += $item['count'];
			
			$refitemsum = $item['value'] * $item['count'];
			$refitemval = round($item['value'] / ($taxes[$item['taxid']]['value']+100) * 100, 2) * $item['count'];
			$refitemtax = $refitemsum - $refitemval;

			$invoicelist[$idx][$item['taxid']]['tax'] -= $refitemtax;
			$invoicelist[$idx][$item['taxid']]['val'] -= $refitemval;
			$invoicelist[$idx]['tax'] -= $refitemtax;
			$invoicelist[$idx]['brutto'] -= $refitemsum;

			$listdata[$item['taxid']]['tax'] -= $refitemtax;
			$listdata[$item['taxid']]['val'] -= $refitemval;
			$listdata['tax'] -= $refitemtax;
			$listdata['brutto'] -= $refitemsum;
		}
		
		$sum = $row['value'] * $row['count'];
		$val = round($row['value'] / ($taxes[$taxid]['value']+100) * 100, 2) * $row['count'];
		$tax = $sum - $val;

		$invoicelist[$idx][$taxid]['tax'] += $tax;
		$invoicelist[$idx][$taxid]['val'] += $val;
		$invoicelist[$idx]['tax'] += $tax;
		$invoicelist[$idx]['brutto'] += $sum;
		
		if(!isset($listdata[$taxid]))
		{
			$listdata[$taxid]['tax'] = 0;
			$listdata[$taxid]['val'] = 0;
		}
		
		$listdata[$taxid]['tax'] += $tax;
		$listdata[$taxid]['val'] += $val;
		$listdata['tax'] += $tax;
		$listdata['brutto'] += $sum;
	}
	
	// get used tax rates for building report table
	foreach($listdata as $idx => $val)
		if(is_int($idx))
			$taxeslist[$idx] = $taxes[$idx];
}

$SMARTY->assign('listdata', $listdata);
$SMARTY->assign('taxes', $taxeslist);
$SMARTY->assign('taxescount', sizeof($taxeslist));
$SMARTY->assign('layout', $layout);
$SMARTY->assign('invoicelist', $invoicelist);

if(isset($_POST['extended']))
{
	$pages = array();
	$totals = array();
	$reccount = sizeof($invoicelist);
	
	// hidden option: records count for one page of printout
	// I thinks 20 records is fine, but someone needs 19.
	$rows = isset($CONFIG['phpui']['printout_pagelimit']) ? $CONFIG['phpui']['printout_pagelimit'] : 20;
	
	// create a new array for use with {section}
	// and do some calculations (summaries)
	$i=1;
	foreach($invoicelist as $row)
	{
		$invoicelist2[] = $row;
		
		$page = ceil($i/$rows);
		
		$totals[$page]['total'] += $row['brutto'];
		$totals[$page]['sumtax'] += $row['tax'];
	
		foreach($taxeslist as $idx => $tax)
		{
			$totals[$page]['val'][$idx] += $row[$idx]['val'];
			$totals[$page]['tax'][$idx] += $row[$idx]['tax'];
		}
		
		$i++;
	}

	foreach($totals as $page => $t)
	{
		$pages[] = $page;

		$totals[$page]['alltotal'] = $totals[$page-1]['alltotal'] + $t['total'];
		$totals[$page]['allsumtax'] = $totals[$page-1]['allsumtax'] + $t['sumtax'];

		foreach($taxeslist as $idx => $tax)
		{
			$totals[$page]['allval'][$idx] = $totals[$page-1]['allval'][$idx] + $t['val'][$idx];
			$totals[$page]['alltax'][$idx] = $totals[$page-1]['alltax'][$idx] + $t['tax'][$idx];
		}
	}

	$SMARTY->assign('invoicelist', $invoicelist2);
	$SMARTY->assign('pages', $pages);
	$SMARTY->assign('rows', $rows);
	$SMARTY->assign('totals', $totals);
	$SMARTY->assign('pagescount', sizeof($pages));
	$SMARTY->assign('reccount', $reccount);
	$SMARTY->display('invoicereport-ext.html');
}
else
	$SMARTY->display('invoicereport.html');

?>
