<?php

/*
 * LMS version 1.11.7 Bastet
 *
 *  (C) Copyright 2001-2009 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: mysql.2005060300.php,v 1.9 2009/01/13 07:45:38 alec Exp $
 */

$DB->Execute("ALTER TABLE customers CHANGE pesel ssn varchar(11) DEFAULT '' NOT NULL");
$DB->Execute("ALTER TABLE customers CHANGE nip ten varchar(16) DEFAULT '' NOT NULL");

$DB->Execute("ALTER TABLE cash DROP INDEX invoiceid");
$DB->Execute("ALTER TABLE cash CHANGE invoiceid docid INT(11) DEFAULT '0' NOT NULL");
$DB->Execute("ALTER TABLE cash ADD INDEX docid (docid)");

$DB->Execute("ALTER TABLE invoicecontents DROP INDEX invoiceid");
$DB->Execute("ALTER TABLE invoicecontents CHANGE invoiceid docid INT(11) DEFAULT '0' NOT NULL");
$DB->Execute("ALTER TABLE invoicecontents ADD INDEX docid (docid)");

$DB->Execute("CREATE TABLE documents (
	id int(11) NOT NULL auto_increment,
	type tinyint NOT NULL DEFAULT '0',
	number int(11) NOT NULL DEFAULT '0',
	cdate int(11) NOT NULL DEFAULT '0',
        customerid int(11) NOT NULL DEFAULT '0',
	userid int(11) NOT NULL DEFAULT '0',
	name varchar(255) NOT NULL DEFAULT '',
	address varchar(255) NOT NULL DEFAULT '',
	zip varchar(10) NOT NULL DEFAULT '',
	city varchar(32) NOT NULL DEFAULT '',
	ten varchar(16) NOT NULL DEFAULT '',
	ssn varchar(11) NOT NULL DEFAULT '',
	paytime tinyint NOT NULL DEFAULT '0',
	paytype varchar(255) NOT NULL DEFAULT '',
	PRIMARY KEY (id)
)");
$DB->Execute("INSERT INTO documents (id, type, number, cdate, paytime, paytype, customerid, userid, name, address, zip, city, ten, ssn)
	SELECT invoices.id, 1, number, cdate, paytime, paytype, invoices.customerid, cash.userid, name, address, zip, city, nip, pesel
	FROM invoices LEFT JOIN cash ON (invoices.id = cash.docid)
	WHERE cash.type = 4
	GROUP BY invoices.id, number, cdate, paytime, paytype, invoices.customerid, cash.userid, name, address, zip, city, nip, pesel");
$DB->Execute("DROP TABLE invoices");
$DB->Execute("ALTER TABLE documents ADD INDEX cdate (cdate)");
	
$DB->Execute("CREATE TABLE receiptcontents (
	docid INT(11) NOT NULL DEFAULT '0',
	itemid TINYINT NOT NULL DEFAULT '0',
	value decimal(9,2) NOT NULL DEFAULT '0',
	description varchar(255) NOT NULL DEFAULT '',
	INDEX docid (docid))
");

$DB->Execute("UPDATE dbinfo SET keyvalue = ? WHERE keytype = ?",array('2005060300', 'dbversion'));

?>
