<?php

/*
 * LMS version 1.10.2 Roham
 *
 *  (C) Copyright 2001-2007 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: invoice_pdf.php,v 1.72.2.2 2007/08/30 09:23:17 alec Exp $
 */
// Faktury w PDF, do uycia z formularzami FT-0100 (c) Polarnet
// w razie pyta mailto:lexx@polarnet.org

function invoice_simple_form_fill($x,$y,$scale)  
{
    global $pdf,$invoice,$CONFIG;
    $finances = $CONFIG['finances'];
    $pdf->setlinestyle(1);

    $pdf->line(7*$scale+$x,724*$scale+$y,7*$scale+$x,694*$scale+$y);
    $pdf->line(7*$scale+$x,724*$scale+$y,37*$scale+$x,724*$scale+$y);
    $pdf->line(370*$scale+$x,724*$scale+$y,370*$scale+$x,694*$scale+$y);
    $pdf->line(370*$scale+$x,724*$scale+$y,340*$scale+$x,724*$scale+$y);
    $pdf->line(7*$scale+$x,197*$scale+$y,7*$scale+$x,227*$scale+$y);
    $pdf->line(7*$scale+$x,197*$scale+$y,37*$scale+$x,197*$scale+$y);
    $pdf->line(370*$scale+$x,197*$scale+$y,370*$scale+$x,227*$scale+$y);
    $pdf->line(370*$scale+$x,197*$scale+$y,340*$scale+$x,197*$scale+$y);
    
    text_autosize(15*$scale+$x,568*$scale+$y,30*$scale, iconv("UTF-8","ISO-8859-2//TRANSLIT",$finances['shortname']),350*$scale);
    text_autosize(15*$scale+$x,534*$scale+$y,30*$scale, iconv("UTF-8","ISO-8859-2//TRANSLIT",$finances['address']),350*$scale);
    text_autosize(15*$scale+$x,500*$scale+$y,30*$scale, iconv("UTF-8","ISO-8859-2//TRANSLIT",$finances['zip']." ".$finances['city']),350*$scale);
    $tmp = bankaccount($invoice['customerid']);
    //text_autosize(15*$scale+$x,683*$scale+$y,30*$scale, substr($tmp,0,17),350*$scale);
    //text_autosize(15*$scale+$x,626*$scale+$y,30*$scale, substr($tmp,18,200),350*$scale);
    text_autosize(15*$scale+$x,683*$scale+$y,30*$scale, $tmp,350*$scale);
    text_autosize(15*$scale+$x,445*$scale+$y,30*$scale,"*".number_format($invoice['total'],2,',','')."*",350*$scale);

    text_autosize(15*$scale+$x,390*$scale+$y,30*$scale, iconv("UTF-8","ISO-8859-2//TRANSLIT",$invoice['name']),350*$scale);
    text_autosize(15*$scale+$x,356*$scale+$y,30*$scale, iconv("UTF-8","ISO-8859-2//TRANSLIT",$invoice['address']),350*$scale);
    text_autosize(15*$scale+$x,322*$scale+$y,30*$scale, iconv("UTF-8","ISO-8859-2//TRANSLIT",$invoice['zip']." ".$invoice['city']),350*$scale);

    $tmp = docnumber($invoice['number'], $invoice['template'], $invoice['cdate']);
    text_autosize(15*$scale+$x,215*$scale+$y,30*$scale,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Payment for invoice No. $0',$tmp)),350*$scale);
}

function invoice_main_form_fill($x,$y,$scale)	
{
    global $pdf,$invoice,$CONFIG;
    $finances = $CONFIG['finances'];
    $pdf->setlinestyle(1);

    $pdf->line(7*$scale+$x,724*$scale+$y,7*$scale+$x,694*$scale+$y);
    $pdf->line(7*$scale+$x,724*$scale+$y,37*$scale+$x,724*$scale+$y);
    $pdf->line(970*$scale+$x,724*$scale+$y,970*$scale+$x,694*$scale+$y);
    $pdf->line(970*$scale+$x,724*$scale+$y,940*$scale+$x,724*$scale+$y);
    $pdf->line(7*$scale+$x,172*$scale+$y,7*$scale+$x,202*$scale+$y);
    $pdf->line(7*$scale+$x,172*$scale+$y,37*$scale+$x,172*$scale+$y);

    text_autosize(15*$scale+$x,680*$scale+$y,30*$scale,iconv("UTF-8","ISO-8859-2//TRANSLIT",$finances['name']),950*$scale);
    text_autosize(15*$scale+$x,617*$scale+$y,30*$scale,iconv("UTF-8","ISO-8859-2//TRANSLIT",$finances['address']." ".$finances['zip']." ".$finances['city']),950*$scale);
    text_autosize(15*$scale+$x,555*$scale+$y,30*$scale,bankaccount($invoice['customerid']),950*$scale);
    $pdf->addtext(330*$scale+$x,495*$scale+$y,30*$scale,'X');
    text_autosize(550*$scale+$x,495*$scale+$y,30*$scale,"*".number_format($invoice['total'],2,',','')."*",400*$scale);
    text_autosize(15*$scale+$x,434*$scale+$y,30*$scale,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('$0 dollars $1 cents',to_words(floor($invoice['total'])),to_words(round(($invoice['total']-floor($invoice['total']))*100)))),950*$scale);
    text_autosize(15*$scale+$x,372*$scale+$y,30*$scale, iconv("UTF-8","ISO-8859-2//TRANSLIT",$invoice['name']),950*$scale);
    text_autosize(15*$scale+$x,312*$scale+$y,30*$scale, iconv("UTF-8","ISO-8859-2//TRANSLIT",$invoice['address']." ".$invoice['zip']." ".$invoice['city']),950*$scale);
    $tmp = docnumber($invoice['number'], $invoice['template'], $invoice['cdate']);
    text_autosize(15*$scale+$x,250*$scale+$y,30*$scale,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Payment for invoice No. $0',$tmp)),950*$scale);
}

function invoice_dates($x,$y)
{
    global $invoice,$pdf;
    $font_size=12;
    text_align_right($x,$y,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Settlement date:')).' ');
    $y=$y-text_align_left($x,$y,$font_size,date("Y/m/d",$invoice['cdate']));
    text_align_right($x,$y,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Sale date:')).' ');
    $y=$y-text_align_left($x,$y,$font_size,date("Y/m/d",$invoice['cdate']));
    text_align_right($x,$y,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Deadline:')).' ');
    $y=$y-text_align_left($x,$y,$font_size,date("Y/m/d",$invoice['pdate']));
    text_align_right($x,$y,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Payment type:')).' ');
    $y=$y-text_align_left($x,$y,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",$invoice['paytype']));
    return $y;
}

function invoice_buyer($x,$y) 
{
    global $invoice,$pdf;
    $font_size=10;
    $y=$y-text_align_left($x,$y,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Purchaser:')).'</b>');
    $y=text_wrap($x,$y,350,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",$invoice['name']),'left');
    $y=$y-text_align_left($x,$y,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",$invoice['address']));
    $y=$y-text_align_left($x,$y,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",$invoice['zip']." ".$invoice['city']));
    if ($invoice['ten']) 
	$y=$y-text_align_left($x,$y,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('TEN:')).' '.$invoice['ten']);
    else if ($invoice['ssn']) 
	$y=$y-text_align_left($x,$y,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('SSN:')).' '.$invoice['ssn']);
    $y=$y-text_align_left($x,$y,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Customer No.: $0',sprintf('%04d',$invoice['customerid']))).'</b>');
    return $y;
}

function invoice_seller($x,$y) 
{
    global $pdf,$CONFIG;
    $font_size=10;
    $y=$y-text_align_left($x,$y,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Seller:')).'</b>');
    $tmp = iconv("UTF-8","ISO-8859-2//TRANSLIT", isset($CONFIG['invoices']['header']) ? $CONFIG['invoices']['header'] : '');
    $tmp = str_replace('\n',"\n",$tmp);
    $tmp = explode("\n",$tmp);
    foreach ($tmp as $line) $y=$y-text_align_left($x,$y,$font_size,$line);

    return $y;
}

function invoice_title($x,$y) 
{
    global $invoice,$pdf,$CONFIG,$type;
    $font_size = 16;
    $tmp = docnumber($invoice['number'], $invoice['template'], $invoice['cdate']);
    if(isset($invoice['invoice']))
    	$y=$y-text_align_left($x,$y,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Credit Note No. $0',$tmp)).'</b>');
    else
	$y=$y-text_align_left($x,$y,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Invoice No. $0',$tmp)).'</b>');
    
    if(isset($invoice['invoice']))
    {
	$font_size = 12; $y += 8;
	$tmp = docnumber($invoice['invoice']['number'], $invoice['invoice']['template'], $invoice['invoice']['cdate']);
	$y=$y-text_align_left($x,$y,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('for Invoice No. $0',$tmp)).'</b>');
	$y -= 5;
    }
    
    $font_size = 16;
    $y=$y-text_align_left($x,$y,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",$type));

    if($type==trans('DUPLICATE'))
    {
	    $font_size = 12;
	    $y=$y-text_align_left($x,$y+4,$font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Duplicate draw-up date:').' '.date('Y/m/d')));
    }
    
    if(isset($invoice['invoice']))
    	$y += 10;
    return $y;
}

function invoice_address_box($x,$y) 
{
    global $invoice,$pdf;
    $font_size=12;
/*
    $invoice_name = $invoice['name'];
    if (strlen($invoice_name)>25) 
        $invoice_name = preg_replace('/(.{25})/',"$1<i>&gt;</i>\n",$invoice_name);
    $tmp = explode("\n",iconv("UTF-8","ISO-8859-2",$invoice_name));
    foreach ($tmp as $line) $y=$y-text_align_left($x,$y,$font_size,"<b>".$line."</b>");
*/
    $y = text_wrap($x, $y, 160, $font_size, '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",$invoice['name'].'</b>'), 'left');
    if ($invoice['serviceaddr']) {
	$tmp = explode("\n",iconv("UTF-8","ISO-8859-2//TRANSLIT",$invoice['serviceaddr']));
	foreach ($tmp as $line) $y=$y-text_align_left($x,$y,$font_size,'<b>'.$line.'</b>');
    } else {
	$y=$y-text_align_left($x,$y,$font_size,'<b>'.iconv('UTF-8','ISO-8859-2//TRANSLIT',$invoice['address']).'</b>');
	$y=$y-text_align_left($x,$y,$font_size,'<b>'.iconv('UTF-8','ISO-8859-2//TRANSLIT',$invoice['zip']." ".$invoice['city']).'</b>');
    }
    return $y;
}

function invoice_data_row($x,$y,$width,$font_size,$margin,$data,$t_width,$t_justify) 
{
    global $pdf;
    $fy=$y-$margin-$pdf->GetFontHeight($font_size);    
    $left = $x+$margin;
    $ny = $fy;
    $cols = sizeof($data);
    for ($i = 1; $i <= $cols; $i++) {
	$ly = text_wrap($left+$margin, $fy, $t_width[$i]-2*$margin, $font_size,$data[$i],$t_justify[$i]);
	$left = $left + $t_width[$i]+2*$margin;
	if ($ly<$ny) $ny=$ly;
    }
    $left = $x;
    for ($i = 1; $i <= $cols; $i++) {
	$pdf->line($left, $y, $left, $ny+$font_size/2);
	$left = $left + $t_width[$i]+2*$margin;
    }
    $pdf->line($left, $y, $left, $ny+$font_size/2);
    $y=$ny+$font_size/2;
    $pdf->line($x,$y,$x+$width,$y);
    return($y);
}

function invoice_short_data_row($x,$y,$width,$font_size,$margin,$data,$t_width,$t_justify) 
{
    global $pdf;
    $fy=$y-$margin-$pdf->GetFontHeight($font_size);    
    $left = $x+$margin;
    $ny = $fy;
    $cols = sizeof($data);
    for ($i = $cols-3; $i <= $cols; $i++) {
	$ly = text_wrap($left+$margin, $fy, $t_width[$i]-2*$margin, $font_size,$data[$i],$t_justify[$i]);
	$left = $left + $t_width[$i]+2*$margin;
	if ($ly<$ny) $ny=$ly;
    }
    $left = $x;
    for ($i = $cols-3; $i <= $cols; $i++) {
	$pdf->line($left, $y, $left, $ny+$font_size/2);
	$left = $left + $t_width[$i]+2*$margin;
    }
    $pdf->line($left, $y, $left, $ny+$font_size/2);
    $y=$ny+$font_size/2;
    //$pdf->line($x,$y,$x+$width,$y);
    $v = $cols-3;
    $pdf->line($x,$y,$x+$t_width[$v++]+$t_width[$v++]+$t_width[$v++]+$t_width[$v++]+8*$margin,$y);
    return($y);
}

function invoice_data($x,$y,$width,$font_size,$margin) 
{
    global $invoice,$pdf;
    
    $pdf->setlinestyle(0.5);
    $pdf->line($x,$y,$x+$width,$y);
    
    $v = 1;
    $t_data[$v++] = '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('No.')).'</b>';
    $t_data[$v++] = '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Name of Product, Commodity or Service:')).'</b>';
    $t_data[$v++] = '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Product ID:')).'</b>';
    $t_data[$v++] = '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Unit:')).'</b>';
    $t_data[$v++] = '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Amount:')).'</b>';
    if($invoice['discount'])
	    $t_data[$v++] = '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Discount:')).'</b>';
    $t_data[$v++] = '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Unitary Net Value:')).'</b>';
    $t_data[$v++] = '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Net Value:')).'</b>';
    $t_data[$v++] = '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Tax Rate:')).'</b>';
    $t_data[$v++] = '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Tax Value:')).'</b>';
    $t_data[$v++] = '<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Gross Value:')).'</b>';
    
    for ($i = 1; $i < $v; $i++) $t_justify[$i]="center";
    for ($i = 1; $i < $v; $i++) $t_width[$i] = getWrapTextWidth($font_size,$t_data[$i])+2*$margin+2;
    
    // tutaj jeszcze trzeba bdzie sprawdzi jak szeroko maj pola w tabelce pniej
    if ($invoice['content']) foreach ($invoice['content'] as $item)
    {
	$v = 2;
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",$item['description']));
	$tt_width[$v++] = $pdf->getTextWidth($font_size,$item['prodid']);
	$tt_width[$v++] = $pdf->getTextWidth($font_size,$item['content']);
	$tt_width[$v++] = $pdf->getTextWidth($font_size,sprintf('%.2f',$item['count']));
	if($invoice['discount'])
	    $tt_width[$v++] = $pdf->getTextWidth($font_size,sprintf('%.2f%%',$item['discount']));
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['basevalue'])))+6;
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['totalbase'])))+6;
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",$item['taxlabel']))+6;
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['totaltax'])))+6;
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['total'])))+6;
	for ($i = 2; $i < $v; $i++) 
		if(($tt_width[$i]+2*$margin+2)>$t_width[$i])
			$t_width[$i] = $tt_width[$i]+2*$margin+2;
    }
    
    if(isset($invoice['invoice']['content'])) foreach ($invoice['invoice']['content'] as $item)
    {
	$v = 2;
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",$item['description']));
	$tt_width[$v++] = $pdf->getTextWidth($font_size,$item['prodid']);
	$tt_width[$v++] = $pdf->getTextWidth($font_size,$item['content']);
	$tt_width[$v++] = $pdf->getTextWidth($font_size,sprintf('%.2f',$item['count']));
	if($invoice['discount'])
	    $tt_width[$v++] = $pdf->getTextWidth($font_size,sprintf('%.2f%%',$item['discount']));
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['basevalue'])))+6;
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['totalbase'])))+6;
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",$item['taxlabel']))+6;
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['totaltax'])))+6;
	$tt_width[$v++] = $pdf->getTextWidth($font_size,iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['total'])))+6;
	for ($i = 2; $i < $v; $i++) 
		if(($tt_width[$i]+2*$margin+2)>$t_width[$i]) 
			$t_width[$i] = $tt_width[$i]+2*$margin+2;
    }
    // Kolumna 2 bdzie miaa rozmiar ustalany dynamicznie
    $t_width[2] = $width-($t_width[1]+$t_width[3]+$t_width[4]+$t_width[5]+$t_width[6]+$t_width[7]+$t_width[8]+$t_width[9]+$t_width[10]+($invoice['discount'] ? $t_width[11] : 0)+ 2*$margin*($invoice['discount'] ? 11 : 10));
    $y = invoice_data_row($x,$y,$width,$font_size,$margin,$t_data,$t_width,$t_justify);
    $t_justify[11] = $t_justify[10] = $t_justify[9] = $t_justify[8] = $t_justify[7] = $t_justify[6] = $t_justify[5] = "right";
    $t_justify[2] = 'left';

    if(isset($invoice['invoice']))
    {
	// we have credit note, so first print corrected invoice data
	$xx = $x;
        $y = $y-text_align_left($x,$y-10,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Was:')).'</b>');
	$y -= 6;
	$pdf->line($x,$y,$x+$width,$y);
	$lp = 1;
	if ($invoice['invoice']['content']) 
	    foreach ($invoice['invoice']['content'] as $item)
	    {
		$v = 1;
		$t_data[$v++] = $lp;
		$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",$item['description']);
		$t_data[$v++] = $item['prodid'];
		$t_data[$v++] = $item['content'];
		$t_data[$v++] = sprintf('%.2f',$item['count']);
		if($invoice['discount'])
			$t_data[$v++] = sprintf('%.2f%%',$item['discount']);
		$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['basevalue']));
		$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['totalbase']));
		$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",$item['taxlabel']);
		$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['totaltax']));
		$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['total']));
	
		$lp++;
		$y = invoice_data_row($x,$y,$width,$font_size,$margin,$t_data,$t_width,$t_justify);
	    }
    
        $x = $x + ($invoice['discount'] ? 7 : 6)*2*$margin + $t_width[1] + $t_width[2] + $t_width[3] + $t_width[4] + $t_width[5] + $t_width[6] + ($invoice['discount'] ? $t_width[7] : 0);

        $fy=$y-$margin-$pdf->GetFontHeight($font_size);    
	text_align_right($x-$margin,$fy,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Total:')).'</b>');
    
	$v = $invoice['discount'] ? 8 : 7;
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($invoice['invoice']['totalbase']));
        $t_data[$v++] = "<b>x</b>";
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($invoice['invoice']['totaltax']));
        $t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($invoice['invoice']['total']));
    
	$y = invoice_short_data_row($x,$y,$width,$font_size,$margin,$t_data,$t_width,$t_justify);
        $y -= 5;

	$fy=$y-$margin-$pdf->GetFontHeight($font_size);    
        text_align_right($x-$margin,$fy,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('in it:')).'</b>');
	$v = $invoice['discount'] ? 8 : 7;
	$pdf->line($x,$y,$x+$t_width[$v++]+$t_width[$v++]+$t_width[$v++]+$t_width[$v++]+8*$margin,$y);
    
	if ($invoice['invoice']['taxest']) 
	    foreach ($invoice['invoice']['taxest'] as $item) 
	    {
	    	$v = $invoice['discount'] ? 8 : 7;
		$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['base']));
		$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",$item['taxlabel']);
		$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['tax']));
		$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['total']));
		$y = invoice_short_data_row($x,$y,$width,$font_size,$margin,$t_data,$t_width,$t_justify);
	    }
	
	$x = $xx;
	if ($invoice['reason'] != '')
	{
		$y = $y-text_align_left($x,$y-10,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Reason:').' '.$invoice['reason']).'</b>');
		$y -= 10;
	}
	$y = $y-text_align_left($x,$y-10,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Corrected to:')).'</b>');
	$y -= 5;
	$pdf->line($x,$y,$x+$width,$y);
    }
        
    $lp = 1;
    if($invoice['content']) foreach ($invoice['content'] as $item)
    {
	$v = 1;
	$t_data[$v++] = $lp;
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",$item['description']);
	$t_data[$v++] = $item['prodid'];
	$t_data[$v++] = $item['content'];
	$t_data[$v++] = sprintf('%.2f',$item['count']);
	if($invoice['discount'])
		$t_data[$v++] = sprintf('%.2f%%',$item['discount']);
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['basevalue']));
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['totalbase']));
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",$item['taxlabel']);
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['totaltax']));
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['total']));
	
	$lp++;
	$y = invoice_data_row($x,$y,$width,$font_size,$margin,$t_data,$t_width,$t_justify);
    }
    
    $return[1] = $y;
    
    $x = $x + ($invoice['discount'] ? 7 : 6)*2*$margin + $t_width[1] + $t_width[2] + $t_width[3] + $t_width[4] + $t_width[5] + $t_width[6] + ($invoice['discount'] ? $t_width[7] : 0);

    $fy=$y-$margin-$pdf->GetFontHeight($font_size);    
    text_align_right($x-$margin,$fy,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Total:')).'</b>');
    
    $v = $invoice['discount'] ? 8 : 7;
    $t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($invoice['totalbase']));
    $t_data[$v++] = "<b>x</b>";
    $t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($invoice['totaltax']));
    $t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($invoice['total']));

    $y = invoice_short_data_row($x,$y,$width,$font_size,$margin,$t_data,$t_width,$t_justify);
    
    $y = $y - 5;

    $fy=$y-$margin-$pdf->GetFontHeight($font_size);    
    text_align_right($x-$margin,$fy,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('in it:')).'</b>');
    $v = $invoice['discount'] ? 8 : 7;
    $pdf->line($x,$y,$x+$t_width[$v++]+$t_width[$v++]+$t_width[$v++]+$t_width[$v++]+8*$margin,$y);
    
    if ($invoice['taxest']) foreach ($invoice['taxest'] as $item) 
    {
	$v = $invoice['discount'] ? 8 : 7;
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['base']));
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",$item['taxlabel']);
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['tax']));
	$t_data[$v++] = iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($item['total']));
	$y = invoice_short_data_row($x,$y,$width,$font_size,$margin,$t_data,$t_width,$t_justify);
    }

    if(isset($invoice['invoice']))
    {
	$total = $invoice['total'] - $invoice['invoice']['total'];
	$totalbase = $invoice['totalbase'] - $invoice['invoice']['totalbase'];
	$totaltax = $invoice['totaltax'] - $invoice['invoice']['totaltax'];
	
	$y = $y - 5;
	$fy=$y-$margin-$pdf->GetFontHeight($font_size);
	$v = $invoice['discount'] ? 8 : 7;
	$pdf->line($x,$y,$x+$t_width[$v++]+$t_width[$v++]+$t_width[$v++]+$t_width[$v++]+8*$margin,$y);
	text_align_right($x-$margin,$fy,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT", trans('Difference value:')).'</b>');
    
	$v = $invoice['discount'] ? 8 : 7;
	$t_data[$v++] = ($totalbase>0 ? '+' : '') . iconv("UTF-8","ISO-8859-2//TRANSLIT", moneyf($totalbase));
        $t_data[$v++] = "<b>x</b>";
	$t_data[$v++] = ($totaltax>0 ? '+' : '') . iconv("UTF-8","ISO-8859-2//TRANSLIT", moneyf($totaltax));
        $t_data[$v++] = ($total>0 ? '+' : '') . iconv("UTF-8","ISO-8859-2//TRANSLIT", moneyf($total));

	$y = invoice_short_data_row($x,$y,$width,$font_size,$margin,$t_data,$t_width,$t_justify);
    }
    
    $return[2] = $y;

    return $return;
}

function invoice_to_pay($x,$y) 
{
    global $pdf, $invoice;
    if(isset($invoice['rebate']))
	    $y = $y - text_align_left($x,$y,14,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('To repay:')).' '.iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($invoice['value'])));
    else
	    $y = $y - text_align_left($x,$y,14,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('To pay:')).' '.iconv("UTF-8","ISO-8859-2//TRANSLIT",moneyf($invoice['value'])));
    $y = $y - text_align_left($x,$y,10,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('In words:')).' '.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('$0 dollars $1 cents',to_words(floor($invoice['value'])),to_words(round(($invoice['value']-floor($invoice['value']))*100)))));
    return $y;
}

function invoice_expositor ($x,$y) 
{
    global $pdf, $invoice, $CONFIG;
    
    $expositor = isset($invoice['user']) ? $invoice['user'] : (isset($CONFIG['invoices']['default_author']) ? $CONFIG['invoices']['default_author'] : '');
	    
    $y = $y - text_align_left($x,$y,10,iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Expositor:')).' '.iconv("UTF-8","ISO-8859-2//TRANSLIT",$expositor));
    return $y;
}

function invoice_footnote($x, $y, $width, $font_size) 
{
    global $pdf, $CONFIG;
    if(isset($CONFIG['invoices']['footer']) && $CONFIG['invoices']['footer'])
    {
	$y = $y - $pdf->getFontHeight($font_size);
	$y = $y - text_align_left($x,$y,$font_size,'<b>'.iconv("UTF-8","ISO-8859-2//TRANSLIT",trans('Notes:')).'</b>');
	$tmp = iconv("UTF-8","ISO-8859-2//TRANSLIT",$CONFIG['invoices']['footer']);
	$tmp = str_replace('\n',"\n",$tmp);
        $tmp = explode("\n",$tmp);
	foreach ($tmp as $line) $y = text_wrap($x,$y,$width,$font_size,$line,"full");
    }
}

function invoice_body() 
{
    global $invoice,$pdf,$id,$CONFIG;
    
    if(isset($invoice['invoice']))
	    $template = $CONFIG['invoices']['cnote_template_file'];
    else
	    $template = $CONFIG['invoices']['template_file'];

    switch ($template)
    {
	case "standard":
	    $top=800;
	    invoice_dates(500,800);    
    	    invoice_address_box(400,700);
	    $top=invoice_title(30,$top);
	    $top=$top-20;
    	    $top=invoice_seller(30,$top);
	    $top=$top-20;
    	    $top=invoice_buyer(30,$top);
	    $top=$top-20;
    	    $return=invoice_data(30,$top,530,7,2);
	    invoice_expositor(30,$return[1]-20);
    	    $top=$return[2]-20;
	    $top=invoice_to_pay(30,$top);
	    $top=$top-20;
	    invoice_footnote(30,$top,530,10);
	    break;
	case "FT-0100":
	    $top=800;
	    invoice_dates(500,800);    
    	    invoice_address_box(400,700);
	    $top=invoice_title(30,$top);
	    $top=$top-10;
    	    $top=invoice_seller(30,$top);
	    $top=$top-10;
    	    $top=invoice_buyer(30,$top);
	    $top=$top-10;
    	    $return=invoice_data(30,$top,430,6,1);
	    invoice_footnote(470,$top,90,8);
	    invoice_expositor(30,$return[1]-20);
    	    $top=$return[2]-10;
	    invoice_to_pay(30,$top);
	    invoice_main_form_fill(187,3,0.4);
	    invoice_simple_form_fill(14,3,0.4);
	    break;
	default:
	    require($template);
    }
    if(!isset($invoice['last'])) $id=$pdf->newPage(1,$id,'after');
}

require_once(LIB_DIR.'/pdf.php');

$pdf =& init_pdf('A4', 'portrait', trans('Invoices'));

$id = $pdf->getFirstPageId();

if(isset($_GET['print']) && $_GET['print'] == 'cached')
{
	$SESSION->restore('ilm', $ilm);
	$SESSION->remove('ilm');

	if(sizeof($_POST['marks']))
		foreach($_POST['marks'] as $idx => $mark)
			$ilm[$idx] = $mark;

	if(sizeof($ilm))
		foreach($ilm as $mark)
			$ids[] = $mark;

	if(!sizeof($ids))
	{
		$SESSION->close();
		die;
	}

	if(isset($_GET['cash']))
	{
		foreach($ids as $cashid)
			if($invoiceid = $DB->GetOne('SELECT docid FROM cash, documents WHERE docid = documents.id AND (documents.type = ? OR documents.type = ?) AND cash.id = ?', array(DOC_INVOICE, DOC_CNOTE, $cashid)))
				$idsx[] = $invoiceid;
		
		$ids = array_unique((array)$idsx);
	}

	sort($ids);

	if(isset($_GET['original'])) $which[] = trans('ORIGINAL');
        if(isset($_GET['copy'])) $which[] = trans('COPY');
        if(isset($_GET['duplicate'])) $which[] = trans('DUPLICATE');

	if(!sizeof($which)) $which[] = trans('ORIGINAL');

	$count = sizeof($ids) * sizeof($which);
	$i=0;

	foreach($ids as $idx => $invoiceid)
	{
		$invoice = $LMS->GetInvoiceContent($invoiceid);
		$invoice['serviceaddr'] = $LMS->GetCustomerServiceAddress($invoice['customerid']);
		foreach($which as $type)
		{
			$i++;
			if($i == $count) $invoice['last'] = TRUE;
			invoice_body();
		}
	}
}
elseif(isset($_GET['fetchallinvoices']))
{
	$ids = $DB->GetCol('SELECT id FROM documents d
				WHERE cdate >= ? AND cdate <= ? AND (type = ? OR type = ?)'
				.($_GET['customerid'] ? ' AND customerid = '.$_GET['customerid'] : '')
				.' AND NOT EXISTS (
				        SELECT 1 FROM customerassignments a
					JOIN excludedgroups e ON (a.customergroupid = e.customergroupid)
					WHERE e.userid = lms_current_user() AND a.customerid = d.customerid)'
				.' ORDER BY CEIL(cdate/86400), id',
				array($_GET['from'], $_GET['to'], DOC_INVOICE, DOC_CNOTE));
	if(!$ids)
	{
		$SESSION->close();
		die;
	}

	if(isset($_GET['original'])) $which[] = trans('ORIGINAL');
        if(isset($_GET['copy'])) $which[] = trans('COPY');
        if(isset($_GET['duplicate'])) $which[] = trans('DUPLICATE');
	
	if(!sizeof($which)) $which[] = trans('ORIGINAL');
	
	$count = sizeof($ids) * sizeof($which);
	$i=0;

	foreach($ids as $idx => $invoiceid)
	{
		$invoice = $LMS->GetInvoiceContent($invoiceid);
		$invoice['serviceaddr'] = $LMS->GetCustomerServiceAddress($invoice['customerid']);
		foreach($which as $type)
		{
			$i++;
			if($i == $count) $invoice['last'] = TRUE;
			invoice_body();
		}
	}
}
elseif(isset($_GET['fetchsingle']))
{
	$invoice = $LMS->GetInvoiceContent($_GET['id']);
	$invoice['last'] = TRUE;
	$invoice['serviceaddr'] = $LMS->GetCustomerServiceAddress($invoice['customerid']);
	$type = trans('ORIGINAL');
	invoice_body();
}
elseif($invoice = $LMS->GetInvoiceContent($_GET['id']))
{
	$invoice['serviceaddr'] = $LMS->GetCustomerServiceAddress($invoice['customerid']);
	$type = trans('ORIGINAL');
	invoice_body();
	$type = trans('COPY');
	$invoice['last'] = TRUE;
	invoice_body();
}
else
{
	$SESSION->redirect('?m=invoicelist');
}

close_pdf($pdf);

?>
