<?php

/*
 * LMS version 1.10.2 Roham
 *
 *  (C) Copyright 2001-2007 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: postgres.2007071100.php,v 1.1.2.1 2007/08/17 13:15:20 alec Exp $
 */

$DB->BeginTrans();

$DB->Execute("
    CREATE SEQUENCE \"customercontacts_id_seq\";
    CREATE TABLE customercontacts (
	    id integer DEFAULT nextval('customercontacts_id_seq'::text) NOT NULL,
	    customerid integer NOT NULL DEFAULT 0,
	    name varchar(255) NOT NULL DEFAULT '',
	    phone varchar(255) NOT NULL DEFAULT '',
	    PRIMARY KEY (id)
    );
    
    CREATE INDEX customercontacts_customerid_idx ON customercontacts (customerid);
    CREATE INDEX customercontacts_phone_idx ON customercontacts (phone);
");

if($list = $DB->GetAll('SELECT phone1, phone2, phone3, id FROM customers'))
{
	foreach($list as $row)
	{
		if(trim($row['phone1']))
			$DB->Execute('INSERT INTO customercontacts (customerid, phone)
					VALUES(?, ?)', array($row['id'], $row['phone1'])); 
		if(trim($row['phone2']))
			$DB->Execute('INSERT INTO customercontacts (customerid, phone)
					VALUES(?, ?)', array($row['id'], $row['phone2']));
		if(trim($row['phone3']))
			$DB->Execute('INSERT INTO customercontacts (customerid, phone)
					VALUES(?, ?)', array($row['id'], $row['phone3']));
	}
}

$DB->Execute("
    ALTER TABLE customers DROP phone1;
    ALTER TABLE customers DROP phone2;
    ALTER TABLE customers DROP phone3;
");

$DB->Execute("UPDATE dbinfo SET keyvalue = ? WHERE keytype = ?", array('2007071100', 'dbversion'));

$DB->CommitTrans();

?>
