<?php

/*
 * LMS version 1.10.2 Roham
 *
 *  (C) Copyright 2001-2007 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: pdf.php,v 1.1.2.2 2007/08/23 11:14:48 alec Exp $
 */

function text_autosize($x,$y,$size,$text,$width) 
{
    global $pdf;
    while ($pdf->getTextWidth($size,$text)>$width) $size=$size-1;
    $pdf->addtext($x,$y,$size,$text);
}

function text_align_right($x,$y,$size,$text) 
{
    global $pdf;
    $pdf->addText($x-$pdf->getTextWidth($size,$text),$y,$size,$text);
    return($pdf->getFontHeight($size));
}

function text_align_left($x,$y,$size,$text) 
{
    global $pdf;
    $pdf->addText($x,$y,$size,$text);
    return($pdf->getFontHeight($size));
}

function text_align_center($x,$y,$size,$text) 
{
    global $pdf;
    $pdf->addText($x - $pdf->getTextWidth($size,$text)/2,$y,$size,$text);
    return $pdf->getFontHeight($size);
}

function text_wrap($x,$y,$width,$size,$text,$justify) 
{
    global $pdf;
    while ($text!='') {
	$text = $pdf->addTextWrap($x, $y, $width, $size,$text,$justify);
	$y = $y - $pdf->getFontHeight($size);
    }
    return($y);
}

function getWrapTextWidth($font_size,$txt)
{
    global $pdf, $margin;
    
    $long = '';
    if($words = explode(' ', $txt))
    {
        foreach($words as $word)
	    if(strlen($word) > strlen($long))
		$long = $word;
    }
    else
	    $long = $txt;
    
    return $pdf->getTextWidth($font_size, $long)+2*$margin+1;
}

// brzydki hack dla ezpdf 
@setlocale(LC_NUMERIC, 'C');
require_once(LIB_DIR.'/ezpdf/class.ezpdf.php');

function init_pdf($pagesize, $orientation, $title)
{
	global $layout;
	
	$diff = array(
		177=>'aogonek',
		161=>'Aogonek',
		230=>'cacute',
		198=>'Cacute',
		234=>'eogonek',
		202=>'Eogonek',
		241=>'nacute',
		209=>'Nacute',
		179=>'lslash',
		163=>'Lslash',
		182=>'sacute',
		166=>'Sacute',
		188=>'zacute',
	        172=>'Zacute',
		191=>'zdot',
		175=>'Zdot'
	);

	$tmp = array(
	    'b'=>'arialbd.afm',
	);

	$pdf =& new Cezpdf('A4', $orientation); //landscape/portrait

	$pdf->addInfo('Producer','LMS Developers');
	$pdf->addInfo('Title',iconv("UTF-8","ISO-8859-2//TRANSLIT",$title));
	$pdf->addInfo('Creator','LMS '.$layout['lmsv']);
	$pdf->setPreferences('FitWindow','1');
	$pdf->ezSetMargins(0,0,0,0);
	$pdf->setLineStyle(0.5);
	$pdf->setFontFamily('arial.afm',$tmp);
	$pdf->selectFont(LIB_DIR.'/ezpdf/arialbd.afm',
			array('encoding'=>'WinAnsiEncoding',
				'differences'=>$diff));
	$pdf->selectFont(LIB_DIR.'/ezpdf/arial.afm',
			array('encoding'=>'WinAnsiEncoding',
				'differences'=>$diff));
	
	return $pdf;
}

function close_pdf(&$pdf)
{
	$pdf->ezStream();
}

?>
