<?php

/*
 * LMS version 1.10.2 Roham
 *
 *  (C) Copyright 2001-2007 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: LMSDB.php,v 1.14.2.1 2007/08/17 13:15:11 alec Exp $
 */

/*
 * Simple database abstraction layer for LMS. Mainly inspirated by ADOdb,
 * but not so much powerfull. Hope that this bit of code will work stable.
 *
 * This file include required files and do some nasty things ;>
 */

define('LMSDB_DIR',dirname(__FILE__));

require_once(LMSDB_DIR.'/LMSDB_common.class.php');

function DBInit($dbtype,$dbhost,$dbuser,$dbpasswd,$dbname)
{
	if(! file_exists(LMSDB_DIR.'/LMSDB_driver_'.strtolower($dbtype).'.class.php') )
		trigger_error('Unable to load driver for "'.$dbtype.'" database!');
	else
	{
		require_once(LMSDB_DIR.'/LMSDB_driver_'.strtolower($dbtype).'.class.php');
		$drvname = 'LMSDB_driver_'.strtolower($dbtype);
		$DB =& new $drvname($dbhost,$dbuser,$dbpasswd,$dbname);
		if(! $DB->_loaded)
			trigger_error('Failed to load driver for "'.$dbtype.'" database: driver doesn\'t seems to be loaded.');
		else
			return $DB;
	}

	return FALSE;
}

?>
