<?php

/*
 * LMS version 1.1.2b
 *
 *  (C) Copyright 2001-2003 LMS Developers
 *
 *  Please, see the doc/AUTHORS for more information about authors!
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 *
 *  $Id: LMSDB_common.class.php,v 1.13 2003/08/24 13:10:26 lukasz Exp $
 */

/*
 * LMSDB - klasa wsplna.
 */

Class LMSDB_common
{
	var $_version="1.1.2b";
	var $_revision='$Revision: 1.13 $';
	
	// Driver powinien nadpisa t zmienn wartoci TRUE, eby
	// funkcja inicjujca baze danych wiedziaa e driver si poprawnie
	// zaadowa
	
	var $_loaded=FALSE;

	// Wewntrzne zmienne bazy danych, tj, resource, link, itp.

	var $_dbtype='NONE';
	var $_dblink=NULL;
	var $_dbhost=NULL;
	var $_dbuser=NULL;
	var $_dbname=NULL;
	var $_error=NULL;
	var $_query=NULL;
	var $_result=NULL;

	function LMSDB_common()
	{
		// zabezpieczmy si przed inicjowaniem tej klasy samej w sobie
		
		die();

	}
	
	function Connect($dbhost,$dbuser,$dbpasswd,$dbname)
	{

		// Inicjuje poczenie do bazy danych
	
		$this->_driver_connect($dbhost,$dbuser,$dbpasswd,$dbname);
	}

	function Execute($query, $inputarray = NULL)
	{

		// wykonuje query sql'owe, jednoczenie je parsujc
	
		return $this->_driver_execute($this->_query_parser($query,$inputarray));
	}

	function GetAll($query = NULL, $inputarray = NULL)
	{

		// zwraca tablic z caym wynikiem
	
		if($query)
			$this->Execute($query, $inputarray);

		while($row = $this->_driver_fetchrow_assoc())
			$result[] = $row;
		
		return $result;
	}

	function GetAllByKey($query = NULL, $key = NULL, $inputarray = NULL)
	{
		if($query)
			$this->Execute($query, $inputarray);

		while($row = $this->_driver_fetchrow_assoc())
			$result[$row[$key]] = $row;

		return $result;
	}

	function GetRow($query = NULL, $inputarray = NULL)
	{
		if($query)
			$this->Execute($query, $inputarray);

		return $this->_driver_fetchrow_assoc();
	}

	function GetCol($query = NULL, $inputarray = NULL)
	{
		if($query)
			$this->Execute($query, $inputarray);

		while($row = $this->_driver_fetchrow_num())
			$result[] = $row[0];
		
		return $result;
	}

	function GetOne($query = NULL, $inputarray = NULL)
	{
		if($query)
			$this->Execute($query, $inputarray);

		list($result) = $this->_driver_fetchrow_num();

		return $result;
	}

	function Concat()
	{
		return $this->_driver_concat(func_get_args());
	}

	function Now()
	{
		return $this->_driver_now();
	}

	function ListTables()
	{
		return $this->_driver_listtables();
	}

	function _query_parser($query, $inputarray = NULL)
	{
		// najpierw sparsujmy wszystkie specjalne meta mieci.
		$query = eregi_replace('\?NOW\?',$this->_driver_now(),$query);
		$query = eregi_replace('\?LIKE\?',$this->_driver_like(),$query);
		if($inputarray)
		{
			$queryelements = explode("\0",str_replace('?',"?\0",$query));
			$query = '';
			foreach($queryelements as $queryelement)
			{
				if(strpos($queryelement,'?') !== FALSE)
				{
					list($key,$value) = each($inputarray);
					$queryelement = str_replace('?',$this->_quote_value($value),$queryelement);
				}
				$query .= $queryelement;
			}
		}
		return $query;
	}

	function _quote_value($input)
	{
		// jeeli baza danych wymaga innego eskejpowania ni to, driver
		// powinien nadpisa t funkcj

		if($input === NULL)
			return 'NULL';
		elseif(gettype($input) == 'string')
			return '\''.addcslashes($input,"'\\\0").'\'';
		else
			return $input;
	}

	// Funkcje bezpieczestwa, tj. na wypadek gdyby driver ich nie
	// zdefiniowa.

	function _driver_now()
	{
		return time();
	}

	function _driver_like()
	{
		return 'LIKE';
	}

}

/* 
 * $Log: LMSDB_common.class.php,v $
 * Revision 1.13  2003/08/24 13:10:26  lukasz
 * - added few comments
 * - s/<?/<?php/g
 *
 * Revision 1.12  2003/08/24 00:59:29  lukasz
 * - LMSDB: GetAllByKey($query, $key, $inputarray)
 * - LMS: more fixes for new DAL
 *
 * Revision 1.11  2003/08/22 13:15:17  lukasz
 * - ListTables()
 *
 * Revision 1.10  2003/08/19 01:01:57  lukasz
 * - added Now() and Concat(), fixed Connect() (doesn't invoke _driver_selectdb(), because pgsql doesn't have _driver_selectdb())
 *
 * Revision 1.9  2003/08/18 16:47:37  lukasz
 * - once again fixed CVS tags
 *
 * Revision 1.8  2003/08/18 16:46:50  lukasz
 * - fixed CVS tags
 * - beta state - need testing
 *
 */

?>
